// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> IP address allocation method. </summary>
    public readonly partial struct NetworkIPAllocationMethod : IEquatable<NetworkIPAllocationMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkIPAllocationMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkIPAllocationMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StaticValue = "Static";
        private const string DynamicValue = "Dynamic";

        /// <summary> Static. </summary>
        public static NetworkIPAllocationMethod Static { get; } = new NetworkIPAllocationMethod(StaticValue);
        /// <summary> Dynamic. </summary>
        public static NetworkIPAllocationMethod Dynamic { get; } = new NetworkIPAllocationMethod(DynamicValue);
        /// <summary> Determines if two <see cref="NetworkIPAllocationMethod"/> values are the same. </summary>
        public static bool operator ==(NetworkIPAllocationMethod left, NetworkIPAllocationMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkIPAllocationMethod"/> values are not the same. </summary>
        public static bool operator !=(NetworkIPAllocationMethod left, NetworkIPAllocationMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkIPAllocationMethod"/>. </summary>
        public static implicit operator NetworkIPAllocationMethod(string value) => new NetworkIPAllocationMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkIPAllocationMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkIPAllocationMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
