// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> HTTP configuration of the connectivity check. </summary>
    public partial class NetworkHttpConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkHttpConfiguration"/>. </summary>
        public NetworkHttpConfiguration()
        {
            Headers = new ChangeTrackingList<NetworkWatcherHttpHeader>();
            ValidStatusCodes = new ChangeTrackingList<int>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkHttpConfiguration"/>. </summary>
        /// <param name="method"> HTTP method. </param>
        /// <param name="headers"> List of HTTP headers. </param>
        /// <param name="validStatusCodes"> Valid status codes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkHttpConfiguration(NetworkWatcherHttpMethod? method, IList<NetworkWatcherHttpHeader> headers, IList<int> validStatusCodes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Method = method;
            Headers = headers;
            ValidStatusCodes = validStatusCodes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> HTTP method. </summary>
        public NetworkWatcherHttpMethod? Method { get; set; }
        /// <summary> List of HTTP headers. </summary>
        public IList<NetworkWatcherHttpHeader> Headers { get; }
        /// <summary> Valid status codes. </summary>
        public IList<int> ValidStatusCodes { get; }
    }
}
