// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The connection status. </summary>
    public readonly partial struct NetworkConnectionStatus : IEquatable<NetworkConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ConnectedValue = "Connected";
        private const string DisconnectedValue = "Disconnected";
        private const string DegradedValue = "Degraded";

        /// <summary> Unknown. </summary>
        public static NetworkConnectionStatus Unknown { get; } = new NetworkConnectionStatus(UnknownValue);
        /// <summary> Connected. </summary>
        public static NetworkConnectionStatus Connected { get; } = new NetworkConnectionStatus(ConnectedValue);
        /// <summary> Disconnected. </summary>
        public static NetworkConnectionStatus Disconnected { get; } = new NetworkConnectionStatus(DisconnectedValue);
        /// <summary> Degraded. </summary>
        public static NetworkConnectionStatus Degraded { get; } = new NetworkConnectionStatus(DegradedValue);
        /// <summary> Determines if two <see cref="NetworkConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(NetworkConnectionStatus left, NetworkConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(NetworkConnectionStatus left, NetworkConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkConnectionStatus"/>. </summary>
        public static implicit operator NetworkConnectionStatus(string value) => new NetworkConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
