// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Parameters to compare with network configuration. </summary>
    public partial class NetworkConfigurationDiagnosticProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkConfigurationDiagnosticProfile"/>. </summary>
        /// <param name="direction"> The direction of the traffic. </param>
        /// <param name="protocol"> Protocol to be verified on. Accepted values are '*', TCP, UDP. </param>
        /// <param name="source"> Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag. </param>
        /// <param name="destination"> Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag. </param>
        /// <param name="destinationPort"> Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="protocol"/>, <paramref name="source"/>, <paramref name="destination"/> or <paramref name="destinationPort"/> is null. </exception>
        public NetworkConfigurationDiagnosticProfile(NetworkTrafficDirection direction, string protocol, string source, string destination, string destinationPort)
        {
            Argument.AssertNotNull(protocol, nameof(protocol));
            Argument.AssertNotNull(source, nameof(source));
            Argument.AssertNotNull(destination, nameof(destination));
            Argument.AssertNotNull(destinationPort, nameof(destinationPort));

            Direction = direction;
            Protocol = protocol;
            Source = source;
            Destination = destination;
            DestinationPort = destinationPort;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkConfigurationDiagnosticProfile"/>. </summary>
        /// <param name="direction"> The direction of the traffic. </param>
        /// <param name="protocol"> Protocol to be verified on. Accepted values are '*', TCP, UDP. </param>
        /// <param name="source"> Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag. </param>
        /// <param name="destination"> Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag. </param>
        /// <param name="destinationPort"> Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkConfigurationDiagnosticProfile(NetworkTrafficDirection direction, string protocol, string source, string destination, string destinationPort, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Direction = direction;
            Protocol = protocol;
            Source = source;
            Destination = destination;
            DestinationPort = destinationPort;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkConfigurationDiagnosticProfile"/> for deserialization. </summary>
        internal NetworkConfigurationDiagnosticProfile()
        {
        }

        /// <summary> The direction of the traffic. </summary>
        public NetworkTrafficDirection Direction { get; set; }
        /// <summary> Protocol to be verified on. Accepted values are '*', TCP, UDP. </summary>
        public string Protocol { get; set; }
        /// <summary> Traffic source. Accepted values are '*', IP Address/CIDR, Service Tag. </summary>
        public string Source { get; set; }
        /// <summary> Traffic destination. Accepted values are: '*', IP Address/CIDR, Service Tag. </summary>
        public string Destination { get; set; }
        /// <summary> Traffic destination port. Accepted values are '*' and a single port in the range (0 - 65535). </summary>
        public string DestinationPort { get; set; }
    }
}
