// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> VPN client authentication method. </summary>
    public readonly partial struct NetworkAuthenticationMethod : IEquatable<NetworkAuthenticationMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkAuthenticationMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkAuthenticationMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EaptlsValue = "EAPTLS";
        private const string EapmschaPv2Value = "EAPMSCHAPv2";

        /// <summary> EAPTLS. </summary>
        public static NetworkAuthenticationMethod Eaptls { get; } = new NetworkAuthenticationMethod(EaptlsValue);
        /// <summary> EAPMSCHAPv2. </summary>
        public static NetworkAuthenticationMethod EapmschaPv2 { get; } = new NetworkAuthenticationMethod(EapmschaPv2Value);
        /// <summary> Determines if two <see cref="NetworkAuthenticationMethod"/> values are the same. </summary>
        public static bool operator ==(NetworkAuthenticationMethod left, NetworkAuthenticationMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkAuthenticationMethod"/> values are not the same. </summary>
        public static bool operator !=(NetworkAuthenticationMethod left, NetworkAuthenticationMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkAuthenticationMethod"/>. </summary>
        public static implicit operator NetworkAuthenticationMethod(string value) => new NetworkAuthenticationMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkAuthenticationMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkAuthenticationMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
