// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Name of Nat Gateway SKU. </summary>
    public readonly partial struct NatGatewaySkuName : IEquatable<NatGatewaySkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NatGatewaySkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NatGatewaySkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";

        /// <summary> Standard. </summary>
        public static NatGatewaySkuName Standard { get; } = new NatGatewaySkuName(StandardValue);
        /// <summary> Determines if two <see cref="NatGatewaySkuName"/> values are the same. </summary>
        public static bool operator ==(NatGatewaySkuName left, NatGatewaySkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NatGatewaySkuName"/> values are not the same. </summary>
        public static bool operator !=(NatGatewaySkuName left, NatGatewaySkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NatGatewaySkuName"/>. </summary>
        public static implicit operator NatGatewaySkuName(string value) => new NatGatewaySkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NatGatewaySkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NatGatewaySkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
