// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Define match conditions. </summary>
    public partial class MatchCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MatchCondition"/>. </summary>
        /// <param name="matchVariables"> List of match variables. </param>
        /// <param name="operator"> The operator to be matched. </param>
        /// <param name="matchValues"> Match value. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="matchVariables"/> or <paramref name="matchValues"/> is null. </exception>
        public MatchCondition(IEnumerable<MatchVariable> matchVariables, WebApplicationFirewallOperator @operator, IEnumerable<string> matchValues)
        {
            Argument.AssertNotNull(matchVariables, nameof(matchVariables));
            Argument.AssertNotNull(matchValues, nameof(matchValues));

            MatchVariables = matchVariables.ToList();
            Operator = @operator;
            MatchValues = matchValues.ToList();
            Transforms = new ChangeTrackingList<WebApplicationFirewallTransform>();
        }

        /// <summary> Initializes a new instance of <see cref="MatchCondition"/>. </summary>
        /// <param name="matchVariables"> List of match variables. </param>
        /// <param name="operator"> The operator to be matched. </param>
        /// <param name="negationConditon"> Whether this is negate condition or not. </param>
        /// <param name="matchValues"> Match value. </param>
        /// <param name="transforms"> List of transforms. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MatchCondition(IList<MatchVariable> matchVariables, WebApplicationFirewallOperator @operator, bool? negationConditon, IList<string> matchValues, IList<WebApplicationFirewallTransform> transforms, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MatchVariables = matchVariables;
            Operator = @operator;
            NegationConditon = negationConditon;
            MatchValues = matchValues;
            Transforms = transforms;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MatchCondition"/> for deserialization. </summary>
        internal MatchCondition()
        {
        }

        /// <summary> List of match variables. </summary>
        public IList<MatchVariable> MatchVariables { get; }
        /// <summary> The operator to be matched. </summary>
        public WebApplicationFirewallOperator Operator { get; set; }
        /// <summary> Whether this is negate condition or not. </summary>
        public bool? NegationConditon { get; set; }
        /// <summary> Match value. </summary>
        public IList<string> MatchValues { get; }
        /// <summary> List of transforms. </summary>
        public IList<WebApplicationFirewallTransform> Transforms { get; }
    }
}
