// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The state of the managed rule. Defaults to Disabled if not specified. </summary>
    public readonly partial struct ManagedRuleEnabledState : IEquatable<ManagedRuleEnabledState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedRuleEnabledState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedRuleEnabledState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static ManagedRuleEnabledState Disabled { get; } = new ManagedRuleEnabledState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static ManagedRuleEnabledState Enabled { get; } = new ManagedRuleEnabledState(EnabledValue);
        /// <summary> Determines if two <see cref="ManagedRuleEnabledState"/> values are the same. </summary>
        public static bool operator ==(ManagedRuleEnabledState left, ManagedRuleEnabledState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedRuleEnabledState"/> values are not the same. </summary>
        public static bool operator !=(ManagedRuleEnabledState left, ManagedRuleEnabledState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedRuleEnabledState"/>. </summary>
        public static implicit operator ManagedRuleEnabledState(string value) => new ManagedRuleEnabledState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedRuleEnabledState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedRuleEnabledState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
