// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The request for a VIP swap. </summary>
    public partial class LoadBalancerVipSwapContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LoadBalancerVipSwapContent"/>. </summary>
        public LoadBalancerVipSwapContent()
        {
            FrontendIPConfigurations = new ChangeTrackingList<LoadBalancerVipSwapRequestFrontendIPConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="LoadBalancerVipSwapContent"/>. </summary>
        /// <param name="frontendIPConfigurations"> A list of frontend IP configuration resources that should swap VIPs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LoadBalancerVipSwapContent(IList<LoadBalancerVipSwapRequestFrontendIPConfiguration> frontendIPConfigurations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FrontendIPConfigurations = frontendIPConfigurations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A list of frontend IP configuration resources that should swap VIPs. </summary>
        public IList<LoadBalancerVipSwapRequestFrontendIPConfiguration> FrontendIPConfigurations { get; }
    }
}
