// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Tier of a load balancer SKU. </summary>
    public readonly partial struct LoadBalancerSkuTier : IEquatable<LoadBalancerSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LoadBalancerSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LoadBalancerSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegionalValue = "Regional";
        private const string GlobalValue = "Global";

        /// <summary> Regional. </summary>
        public static LoadBalancerSkuTier Regional { get; } = new LoadBalancerSkuTier(RegionalValue);
        /// <summary> Global. </summary>
        public static LoadBalancerSkuTier Global { get; } = new LoadBalancerSkuTier(GlobalValue);
        /// <summary> Determines if two <see cref="LoadBalancerSkuTier"/> values are the same. </summary>
        public static bool operator ==(LoadBalancerSkuTier left, LoadBalancerSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LoadBalancerSkuTier"/> values are not the same. </summary>
        public static bool operator !=(LoadBalancerSkuTier left, LoadBalancerSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LoadBalancerSkuTier"/>. </summary>
        public static implicit operator LoadBalancerSkuTier(string value) => new LoadBalancerSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LoadBalancerSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LoadBalancerSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
