// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections. </summary>
    public readonly partial struct LoadBalancerBackendAddressAdminState : IEquatable<LoadBalancerBackendAddressAdminState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LoadBalancerBackendAddressAdminState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LoadBalancerBackendAddressAdminState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string UpValue = "Up";
        private const string DownValue = "Down";

        /// <summary> None. </summary>
        public static LoadBalancerBackendAddressAdminState None { get; } = new LoadBalancerBackendAddressAdminState(NoneValue);
        /// <summary> Up. </summary>
        public static LoadBalancerBackendAddressAdminState Up { get; } = new LoadBalancerBackendAddressAdminState(UpValue);
        /// <summary> Down. </summary>
        public static LoadBalancerBackendAddressAdminState Down { get; } = new LoadBalancerBackendAddressAdminState(DownValue);
        /// <summary> Determines if two <see cref="LoadBalancerBackendAddressAdminState"/> values are the same. </summary>
        public static bool operator ==(LoadBalancerBackendAddressAdminState left, LoadBalancerBackendAddressAdminState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LoadBalancerBackendAddressAdminState"/> values are not the same. </summary>
        public static bool operator !=(LoadBalancerBackendAddressAdminState left, LoadBalancerBackendAddressAdminState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LoadBalancerBackendAddressAdminState"/>. </summary>
        public static implicit operator LoadBalancerBackendAddressAdminState(string value) => new LoadBalancerBackendAddressAdminState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LoadBalancerBackendAddressAdminState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LoadBalancerBackendAddressAdminState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
