// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Protocol. This should be either TCP or UDP. </summary>
    public readonly partial struct InboundSecurityRulesProtocol : IEquatable<InboundSecurityRulesProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InboundSecurityRulesProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InboundSecurityRulesProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string UdpValue = "UDP";

        /// <summary> TCP. </summary>
        public static InboundSecurityRulesProtocol Tcp { get; } = new InboundSecurityRulesProtocol(TcpValue);
        /// <summary> UDP. </summary>
        public static InboundSecurityRulesProtocol Udp { get; } = new InboundSecurityRulesProtocol(UdpValue);
        /// <summary> Determines if two <see cref="InboundSecurityRulesProtocol"/> values are the same. </summary>
        public static bool operator ==(InboundSecurityRulesProtocol left, InboundSecurityRulesProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InboundSecurityRulesProtocol"/> values are not the same. </summary>
        public static bool operator !=(InboundSecurityRulesProtocol left, InboundSecurityRulesProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InboundSecurityRulesProtocol"/>. </summary>
        public static implicit operator InboundSecurityRulesProtocol(string value) => new InboundSecurityRulesProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InboundSecurityRulesProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InboundSecurityRulesProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
