// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Properties of the Inbound Security Rules resource. </summary>
    public partial class InboundSecurityRules
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InboundSecurityRules"/>. </summary>
        public InboundSecurityRules()
        {
            DestinationPortRanges = new ChangeTrackingList<string>();
            AppliesOn = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="InboundSecurityRules"/>. </summary>
        /// <param name="name"> Name of the rule. </param>
        /// <param name="protocol"> Protocol. This should be either TCP or UDP. </param>
        /// <param name="sourceAddressPrefix"> The CIDR or source IP range. </param>
        /// <param name="destinationPortRange"> NVA port ranges to be opened up. One needs to provide specific ports. </param>
        /// <param name="destinationPortRanges"> NVA port ranges to be opened up. One can provide a range of ports. Allowed port value between 0 and 65535. </param>
        /// <param name="appliesOn"> Public IP name in case of Permanent Rule type &amp; Interface Name in case of Auto Expire Rule type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InboundSecurityRules(string name, InboundSecurityRulesProtocol? protocol, string sourceAddressPrefix, int? destinationPortRange, IList<string> destinationPortRanges, IList<string> appliesOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Protocol = protocol;
            SourceAddressPrefix = sourceAddressPrefix;
            DestinationPortRange = destinationPortRange;
            DestinationPortRanges = destinationPortRanges;
            AppliesOn = appliesOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the rule. </summary>
        public string Name { get; set; }
        /// <summary> Protocol. This should be either TCP or UDP. </summary>
        public InboundSecurityRulesProtocol? Protocol { get; set; }
        /// <summary> The CIDR or source IP range. </summary>
        public string SourceAddressPrefix { get; set; }
        /// <summary> NVA port ranges to be opened up. One needs to provide specific ports. </summary>
        public int? DestinationPortRange { get; set; }
        /// <summary> NVA port ranges to be opened up. One can provide a range of ports. Allowed port value between 0 and 65535. </summary>
        public IList<string> DestinationPortRanges { get; }
        /// <summary> Public IP name in case of Permanent Rule type &amp; Interface Name in case of Auto Expire Rule type. </summary>
        public IList<string> AppliesOn { get; }
    }
}
