// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Rule Type. This should be either AutoExpire or Permanent. Auto Expire Rule only creates NSG rules. Permanent Rule creates NSG rule and SLB LB Rule. </summary>
    public readonly partial struct InboundSecurityRuleType : IEquatable<InboundSecurityRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InboundSecurityRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InboundSecurityRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoExpireValue = "AutoExpire";
        private const string PermanentValue = "Permanent";

        /// <summary> AutoExpire. </summary>
        public static InboundSecurityRuleType AutoExpire { get; } = new InboundSecurityRuleType(AutoExpireValue);
        /// <summary> Permanent. </summary>
        public static InboundSecurityRuleType Permanent { get; } = new InboundSecurityRuleType(PermanentValue);
        /// <summary> Determines if two <see cref="InboundSecurityRuleType"/> values are the same. </summary>
        public static bool operator ==(InboundSecurityRuleType left, InboundSecurityRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InboundSecurityRuleType"/> values are not the same. </summary>
        public static bool operator !=(InboundSecurityRuleType left, InboundSecurityRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InboundSecurityRuleType"/>. </summary>
        public static implicit operator InboundSecurityRuleType(string value) => new InboundSecurityRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InboundSecurityRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InboundSecurityRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
