// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The IKE encryption algorithm (IKE phase 2). </summary>
    public readonly partial struct IkeEncryption : IEquatable<IkeEncryption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IkeEncryption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IkeEncryption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DesValue = "DES";
        private const string Des3Value = "DES3";
        private const string Aes128Value = "AES128";
        private const string Aes192Value = "AES192";
        private const string Aes256Value = "AES256";
        private const string GcmAes256Value = "GCMAES256";
        private const string GcmAes128Value = "GCMAES128";

        /// <summary> DES. </summary>
        public static IkeEncryption Des { get; } = new IkeEncryption(DesValue);
        /// <summary> DES3. </summary>
        public static IkeEncryption Des3 { get; } = new IkeEncryption(Des3Value);
        /// <summary> AES128. </summary>
        public static IkeEncryption Aes128 { get; } = new IkeEncryption(Aes128Value);
        /// <summary> AES192. </summary>
        public static IkeEncryption Aes192 { get; } = new IkeEncryption(Aes192Value);
        /// <summary> AES256. </summary>
        public static IkeEncryption Aes256 { get; } = new IkeEncryption(Aes256Value);
        /// <summary> GCMAES256. </summary>
        public static IkeEncryption GcmAes256 { get; } = new IkeEncryption(GcmAes256Value);
        /// <summary> GCMAES128. </summary>
        public static IkeEncryption GcmAes128 { get; } = new IkeEncryption(GcmAes128Value);
        /// <summary> Determines if two <see cref="IkeEncryption"/> values are the same. </summary>
        public static bool operator ==(IkeEncryption left, IkeEncryption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IkeEncryption"/> values are not the same. </summary>
        public static bool operator !=(IkeEncryption left, IkeEncryption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IkeEncryption"/>. </summary>
        public static implicit operator IkeEncryption(string value) => new IkeEncryption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IkeEncryption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IkeEncryption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
