// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Will describe the query to run against the IDPS signatures DB. </summary>
    public partial class IdpsQueryContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IdpsQueryContent"/>. </summary>
        public IdpsQueryContent()
        {
            Filters = new ChangeTrackingList<IdpsQueryFilterItems>();
        }

        /// <summary> Initializes a new instance of <see cref="IdpsQueryContent"/>. </summary>
        /// <param name="filters"> Contain all filters names and values. </param>
        /// <param name="search"> Search term in all columns. </param>
        /// <param name="orderBy"> Column to sort response by. </param>
        /// <param name="resultsPerPage"> The number of the results to return in each page. </param>
        /// <param name="skip"> The number of records matching the filter to skip. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IdpsQueryContent(IList<IdpsQueryFilterItems> filters, string search, IdpsQueryOrderBy orderBy, int? resultsPerPage, int? skip, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Filters = filters;
            Search = search;
            OrderBy = orderBy;
            ResultsPerPage = resultsPerPage;
            Skip = skip;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Contain all filters names and values. </summary>
        public IList<IdpsQueryFilterItems> Filters { get; }
        /// <summary> Search term in all columns. </summary>
        public string Search { get; set; }
        /// <summary> Column to sort response by. </summary>
        public IdpsQueryOrderBy OrderBy { get; set; }
        /// <summary> The number of the results to return in each page. </summary>
        public int? ResultsPerPage { get; set; }
        /// <summary> The number of records matching the filter to skip. </summary>
        public int? Skip { get; set; }
    }
}
