// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> IPv6 Circuit Connection properties for global reach. </summary>
    public partial class IPv6CircuitConnectionConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IPv6CircuitConnectionConfig"/>. </summary>
        public IPv6CircuitConnectionConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IPv6CircuitConnectionConfig"/>. </summary>
        /// <param name="addressPrefix"> /125 IP address space to carve out customer addresses for global reach. </param>
        /// <param name="circuitConnectionStatus"> Express Route Circuit connection state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IPv6CircuitConnectionConfig(string addressPrefix, CircuitConnectionStatus? circuitConnectionStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AddressPrefix = addressPrefix;
            CircuitConnectionStatus = circuitConnectionStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> /125 IP address space to carve out customer addresses for global reach. </summary>
        public string AddressPrefix { get; set; }
        /// <summary> Express Route Circuit connection state. </summary>
        public CircuitConnectionStatus? CircuitConnectionStatus { get; }
    }
}
