// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The IPSec integrity algorithm (IKE phase 1). </summary>
    public readonly partial struct IPsecIntegrity : IEquatable<IPsecIntegrity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IPsecIntegrity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IPsecIntegrity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MD5Value = "MD5";
        private const string Sha1Value = "SHA1";
        private const string Sha256Value = "SHA256";
        private const string Sha384Value = "SHA384";
        private const string GcmAes256Value = "GCMAES256";
        private const string GcmAes128Value = "GCMAES128";

        /// <summary> MD5. </summary>
        public static IPsecIntegrity MD5 { get; } = new IPsecIntegrity(MD5Value);
        /// <summary> SHA1. </summary>
        public static IPsecIntegrity Sha1 { get; } = new IPsecIntegrity(Sha1Value);
        /// <summary> SHA256. </summary>
        public static IPsecIntegrity Sha256 { get; } = new IPsecIntegrity(Sha256Value);
        /// <summary> SHA384. </summary>
        public static IPsecIntegrity Sha384 { get; } = new IPsecIntegrity(Sha384Value);
        /// <summary> GCMAES256. </summary>
        public static IPsecIntegrity GcmAes256 { get; } = new IPsecIntegrity(GcmAes256Value);
        /// <summary> GCMAES128. </summary>
        public static IPsecIntegrity GcmAes128 { get; } = new IPsecIntegrity(GcmAes128Value);
        /// <summary> Determines if two <see cref="IPsecIntegrity"/> values are the same. </summary>
        public static bool operator ==(IPsecIntegrity left, IPsecIntegrity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IPsecIntegrity"/> values are not the same. </summary>
        public static bool operator !=(IPsecIntegrity left, IPsecIntegrity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IPsecIntegrity"/>. </summary>
        public static implicit operator IPsecIntegrity(string value) => new IPsecIntegrity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IPsecIntegrity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IPsecIntegrity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
