// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The IPSec encryption algorithm (IKE phase 1). </summary>
    public readonly partial struct IPsecEncryption : IEquatable<IPsecEncryption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IPsecEncryption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IPsecEncryption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DesValue = "DES";
        private const string Des3Value = "DES3";
        private const string Aes128Value = "AES128";
        private const string Aes192Value = "AES192";
        private const string Aes256Value = "AES256";
        private const string GcmAes128Value = "GCMAES128";
        private const string GcmAes192Value = "GCMAES192";
        private const string GcmAes256Value = "GCMAES256";

        /// <summary> None. </summary>
        public static IPsecEncryption None { get; } = new IPsecEncryption(NoneValue);
        /// <summary> DES. </summary>
        public static IPsecEncryption Des { get; } = new IPsecEncryption(DesValue);
        /// <summary> DES3. </summary>
        public static IPsecEncryption Des3 { get; } = new IPsecEncryption(Des3Value);
        /// <summary> AES128. </summary>
        public static IPsecEncryption Aes128 { get; } = new IPsecEncryption(Aes128Value);
        /// <summary> AES192. </summary>
        public static IPsecEncryption Aes192 { get; } = new IPsecEncryption(Aes192Value);
        /// <summary> AES256. </summary>
        public static IPsecEncryption Aes256 { get; } = new IPsecEncryption(Aes256Value);
        /// <summary> GCMAES128. </summary>
        public static IPsecEncryption GcmAes128 { get; } = new IPsecEncryption(GcmAes128Value);
        /// <summary> GCMAES192. </summary>
        public static IPsecEncryption GcmAes192 { get; } = new IPsecEncryption(GcmAes192Value);
        /// <summary> GCMAES256. </summary>
        public static IPsecEncryption GcmAes256 { get; } = new IPsecEncryption(GcmAes256Value);
        /// <summary> Determines if two <see cref="IPsecEncryption"/> values are the same. </summary>
        public static bool operator ==(IPsecEncryption left, IPsecEncryption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IPsecEncryption"/> values are not the same. </summary>
        public static bool operator !=(IPsecEncryption left, IPsecEncryption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IPsecEncryption"/>. </summary>
        public static implicit operator IPsecEncryption(string value) => new IPsecEncryption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IPsecEncryption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IPsecEncryption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
