// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Protocol to be verified on. </summary>
    public readonly partial struct IPFlowProtocol : IEquatable<IPFlowProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IPFlowProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IPFlowProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string UdpValue = "UDP";

        /// <summary> TCP. </summary>
        public static IPFlowProtocol Tcp { get; } = new IPFlowProtocol(TcpValue);
        /// <summary> UDP. </summary>
        public static IPFlowProtocol Udp { get; } = new IPFlowProtocol(UdpValue);
        /// <summary> Determines if two <see cref="IPFlowProtocol"/> values are the same. </summary>
        public static bool operator ==(IPFlowProtocol left, IPFlowProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IPFlowProtocol"/> values are not the same. </summary>
        public static bool operator !=(IPFlowProtocol left, IPFlowProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IPFlowProtocol"/>. </summary>
        public static implicit operator IPFlowProtocol(string value) => new IPFlowProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IPFlowProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IPFlowProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
