// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Specify what happens to the public IP address when the VM using it is deleted. </summary>
    public readonly partial struct IPAddressDeleteOption : IEquatable<IPAddressDeleteOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IPAddressDeleteOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IPAddressDeleteOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DetachValue = "Detach";

        /// <summary> Delete. </summary>
        public static IPAddressDeleteOption Delete { get; } = new IPAddressDeleteOption(DeleteValue);
        /// <summary> Detach. </summary>
        public static IPAddressDeleteOption Detach { get; } = new IPAddressDeleteOption(DetachValue);
        /// <summary> Determines if two <see cref="IPAddressDeleteOption"/> values are the same. </summary>
        public static bool operator ==(IPAddressDeleteOption left, IPAddressDeleteOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IPAddressDeleteOption"/> values are not the same. </summary>
        public static bool operator !=(IPAddressDeleteOption left, IPAddressDeleteOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IPAddressDeleteOption"/>. </summary>
        public static implicit operator IPAddressDeleteOption(string value) => new IPAddressDeleteOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IPAddressDeleteOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IPAddressDeleteOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
