// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The hub routing preference gateway types. </summary>
    public readonly partial struct HubRoutingPreference : IEquatable<HubRoutingPreference>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HubRoutingPreference"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HubRoutingPreference(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExpressRouteValue = "ExpressRoute";
        private const string VpnGatewayValue = "VpnGateway";
        private const string ASPathValue = "ASPath";

        /// <summary> ExpressRoute. </summary>
        public static HubRoutingPreference ExpressRoute { get; } = new HubRoutingPreference(ExpressRouteValue);
        /// <summary> VpnGateway. </summary>
        public static HubRoutingPreference VpnGateway { get; } = new HubRoutingPreference(VpnGatewayValue);
        /// <summary> ASPath. </summary>
        public static HubRoutingPreference ASPath { get; } = new HubRoutingPreference(ASPathValue);
        /// <summary> Determines if two <see cref="HubRoutingPreference"/> values are the same. </summary>
        public static bool operator ==(HubRoutingPreference left, HubRoutingPreference right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HubRoutingPreference"/> values are not the same. </summary>
        public static bool operator !=(HubRoutingPreference left, HubRoutingPreference right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HubRoutingPreference"/>. </summary>
        public static implicit operator HubRoutingPreference(string value) => new HubRoutingPreference(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HubRoutingPreference other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HubRoutingPreference other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
