// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Flag if need to use hub gateway. </summary>
    public readonly partial struct HubGatewayUsageFlag : IEquatable<HubGatewayUsageFlag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HubGatewayUsageFlag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HubGatewayUsageFlag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "False";
        private const string TrueValue = "True";

        /// <summary> False. </summary>
        public static HubGatewayUsageFlag False { get; } = new HubGatewayUsageFlag(FalseValue);
        /// <summary> True. </summary>
        public static HubGatewayUsageFlag True { get; } = new HubGatewayUsageFlag(TrueValue);
        /// <summary> Determines if two <see cref="HubGatewayUsageFlag"/> values are the same. </summary>
        public static bool operator ==(HubGatewayUsageFlag left, HubGatewayUsageFlag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HubGatewayUsageFlag"/> values are not the same. </summary>
        public static bool operator !=(HubGatewayUsageFlag left, HubGatewayUsageFlag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HubGatewayUsageFlag"/>. </summary>
        public static implicit operator HubGatewayUsageFlag(string value) => new HubGatewayUsageFlag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HubGatewayUsageFlag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HubGatewayUsageFlag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
