// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The current state of the VirtualHub to Peer. </summary>
    public readonly partial struct HubBgpConnectionStatus : IEquatable<HubBgpConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HubBgpConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HubBgpConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ConnectingValue = "Connecting";
        private const string ConnectedValue = "Connected";
        private const string NotConnectedValue = "NotConnected";

        /// <summary> Unknown. </summary>
        public static HubBgpConnectionStatus Unknown { get; } = new HubBgpConnectionStatus(UnknownValue);
        /// <summary> Connecting. </summary>
        public static HubBgpConnectionStatus Connecting { get; } = new HubBgpConnectionStatus(ConnectingValue);
        /// <summary> Connected. </summary>
        public static HubBgpConnectionStatus Connected { get; } = new HubBgpConnectionStatus(ConnectedValue);
        /// <summary> NotConnected. </summary>
        public static HubBgpConnectionStatus NotConnected { get; } = new HubBgpConnectionStatus(NotConnectedValue);
        /// <summary> Determines if two <see cref="HubBgpConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(HubBgpConnectionStatus left, HubBgpConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HubBgpConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(HubBgpConnectionStatus left, HubBgpConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HubBgpConnectionStatus"/>. </summary>
        public static implicit operator HubBgpConnectionStatus(string value) => new HubBgpConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HubBgpConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HubBgpConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
