// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class HopLink : IUtf8JsonSerializable, IJsonModel<HopLink>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HopLink>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HopLink>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HopLink>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HopLink)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(NextHopId))
            {
                writer.WritePropertyName("nextHopId"u8);
                writer.WriteStringValue(NextHopId);
            }
            if (options.Format != "W" && Optional.IsDefined(LinkType))
            {
                writer.WritePropertyName("linkType"u8);
                writer.WriteStringValue(LinkType);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Issues))
            {
                writer.WritePropertyName("issues"u8);
                writer.WriteStartArray();
                foreach (var item in Issues)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Context))
            {
                writer.WritePropertyName("context"u8);
                writer.WriteStartObject();
                foreach (var item in Context)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceId))
            {
                writer.WritePropertyName("resourceId"u8);
                writer.WriteStringValue(ResourceId);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(RoundTripTimeMin))
            {
                writer.WritePropertyName("roundTripTimeMin"u8);
                writer.WriteNumberValue(RoundTripTimeMin.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RoundTripTimeAvg))
            {
                writer.WritePropertyName("roundTripTimeAvg"u8);
                writer.WriteNumberValue(RoundTripTimeAvg.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RoundTripTimeMax))
            {
                writer.WritePropertyName("roundTripTimeMax"u8);
                writer.WriteNumberValue(RoundTripTimeMax.Value);
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HopLink IJsonModel<HopLink>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HopLink>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HopLink)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHopLink(document.RootElement, options);
        }

        internal static HopLink DeserializeHopLink(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nextHopId = default;
            string linkType = default;
            IReadOnlyList<ConnectivityIssueInfo> issues = default;
            IReadOnlyDictionary<string, string> context = default;
            ResourceIdentifier resourceId = default;
            long? roundTripTimeMin = default;
            long? roundTripTimeAvg = default;
            long? roundTripTimeMax = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("nextHopId"u8))
                {
                    nextHopId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("linkType"u8))
                {
                    linkType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("issues"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ConnectivityIssueInfo> array = new List<ConnectivityIssueInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ConnectivityIssueInfo.DeserializeConnectivityIssueInfo(item, options));
                    }
                    issues = array;
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    context = dictionary;
                    continue;
                }
                if (property.NameEquals("resourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null || property.Value.ValueKind == JsonValueKind.String && property.Value.GetString().Length == 0)
                    {
                        continue;
                    }
                    resourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("roundTripTimeMin"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            roundTripTimeMin = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("roundTripTimeAvg"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            roundTripTimeAvg = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("roundTripTimeMax"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            roundTripTimeMax = property0.Value.GetInt64();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HopLink(
                nextHopId,
                linkType,
                issues ?? new ChangeTrackingList<ConnectivityIssueInfo>(),
                context ?? new ChangeTrackingDictionary<string, string>(),
                resourceId,
                roundTripTimeMin,
                roundTripTimeAvg,
                roundTripTimeMax,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<HopLink>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HopLink>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HopLink)} does not support writing '{options.Format}' format.");
            }
        }

        HopLink IPersistableModel<HopLink>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HopLink>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHopLink(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HopLink)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HopLink>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
