// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> An optional field under "Rewrite Action". It lets you capture and modify the value(s) of a specific header when multiple headers with the same name exist. Currently supported for Set-Cookie Response header only. For more details, visit https://aka.ms/appgwheadercrud. </summary>
    public partial class HeaderValueMatcher
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HeaderValueMatcher"/>. </summary>
        public HeaderValueMatcher()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HeaderValueMatcher"/>. </summary>
        /// <param name="pattern"> The pattern, either fixed string or regular expression, that evaluates if a header value should be selected for rewrite. </param>
        /// <param name="ignoreCase"> Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison. </param>
        /// <param name="negate"> Setting this value as truth will force to check the negation of the condition given by the user in the pattern field. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HeaderValueMatcher(string pattern, bool? ignoreCase, bool? negate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Pattern = pattern;
            IgnoreCase = ignoreCase;
            Negate = negate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The pattern, either fixed string or regular expression, that evaluates if a header value should be selected for rewrite. </summary>
        public string Pattern { get; set; }
        /// <summary> Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison. </summary>
        public bool? IgnoreCase { get; set; }
        /// <summary> Setting this value as truth will force to check the negation of the condition given by the user in the pattern field. </summary>
        public bool? Negate { get; set; }
    }
}
