// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Group connectivity type. </summary>
    public readonly partial struct GroupConnectivity : IEquatable<GroupConnectivity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GroupConnectivity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GroupConnectivity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DirectlyConnectedValue = "DirectlyConnected";

        /// <summary> None. </summary>
        public static GroupConnectivity None { get; } = new GroupConnectivity(NoneValue);
        /// <summary> DirectlyConnected. </summary>
        public static GroupConnectivity DirectlyConnected { get; } = new GroupConnectivity(DirectlyConnectedValue);
        /// <summary> Determines if two <see cref="GroupConnectivity"/> values are the same. </summary>
        public static bool operator ==(GroupConnectivity left, GroupConnectivity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GroupConnectivity"/> values are not the same. </summary>
        public static bool operator !=(GroupConnectivity left, GroupConnectivity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GroupConnectivity"/>. </summary>
        public static implicit operator GroupConnectivity(string value) => new GroupConnectivity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GroupConnectivity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GroupConnectivity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
