// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Define user session identifier group by clauses. </summary>
    public partial class GroupByUserSession
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GroupByUserSession"/>. </summary>
        /// <param name="groupByVariables"> List of group by clause variables. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="groupByVariables"/> is null. </exception>
        public GroupByUserSession(IEnumerable<GroupByVariable> groupByVariables)
        {
            Argument.AssertNotNull(groupByVariables, nameof(groupByVariables));

            GroupByVariables = groupByVariables.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GroupByUserSession"/>. </summary>
        /// <param name="groupByVariables"> List of group by clause variables. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GroupByUserSession(IList<GroupByVariable> groupByVariables, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupByVariables = groupByVariables;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GroupByUserSession"/> for deserialization. </summary>
        internal GroupByUserSession()
        {
        }

        /// <summary> List of group by clause variables. </summary>
        public IList<GroupByVariable> GroupByVariables { get; }
    }
}
