// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Flag if global mesh is supported. </summary>
    public readonly partial struct GlobalMeshSupportFlag : IEquatable<GlobalMeshSupportFlag>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GlobalMeshSupportFlag"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GlobalMeshSupportFlag(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FalseValue = "False";
        private const string TrueValue = "True";

        /// <summary> False. </summary>
        public static GlobalMeshSupportFlag False { get; } = new GlobalMeshSupportFlag(FalseValue);
        /// <summary> True. </summary>
        public static GlobalMeshSupportFlag True { get; } = new GlobalMeshSupportFlag(TrueValue);
        /// <summary> Determines if two <see cref="GlobalMeshSupportFlag"/> values are the same. </summary>
        public static bool operator ==(GlobalMeshSupportFlag left, GlobalMeshSupportFlag right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GlobalMeshSupportFlag"/> values are not the same. </summary>
        public static bool operator !=(GlobalMeshSupportFlag left, GlobalMeshSupportFlag right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GlobalMeshSupportFlag"/>. </summary>
        public static implicit operator GlobalMeshSupportFlag(string value) => new GlobalMeshSupportFlag(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GlobalMeshSupportFlag other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GlobalMeshSupportFlag other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
