// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> List of Vpn-Sites. </summary>
    public partial class GetVpnSitesConfigurationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GetVpnSitesConfigurationContent"/>. </summary>
        /// <param name="outputBlobSasUri"> The sas-url to download the configurations for vpn-sites. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="outputBlobSasUri"/> is null. </exception>
        public GetVpnSitesConfigurationContent(Uri outputBlobSasUri)
        {
            Argument.AssertNotNull(outputBlobSasUri, nameof(outputBlobSasUri));

            VpnSites = new ChangeTrackingList<string>();
            OutputBlobSasUri = outputBlobSasUri;
        }

        /// <summary> Initializes a new instance of <see cref="GetVpnSitesConfigurationContent"/>. </summary>
        /// <param name="vpnSites"> List of resource-ids of the vpn-sites for which config is to be downloaded. </param>
        /// <param name="outputBlobSasUri"> The sas-url to download the configurations for vpn-sites. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GetVpnSitesConfigurationContent(IList<string> vpnSites, Uri outputBlobSasUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VpnSites = vpnSites;
            OutputBlobSasUri = outputBlobSasUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GetVpnSitesConfigurationContent"/> for deserialization. </summary>
        internal GetVpnSitesConfigurationContent()
        {
        }

        /// <summary> List of resource-ids of the vpn-sites for which config is to be downloaded. </summary>
        public IList<string> VpnSites { get; }
        /// <summary> The sas-url to download the configurations for vpn-sites. </summary>
        public Uri OutputBlobSasUri { get; }
    }
}
