// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class GetVpnSitesConfigurationContent : IUtf8JsonSerializable, IJsonModel<GetVpnSitesConfigurationContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GetVpnSitesConfigurationContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GetVpnSitesConfigurationContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetVpnSitesConfigurationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetVpnSitesConfigurationContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(VpnSites))
            {
                writer.WritePropertyName("vpnSites"u8);
                writer.WriteStartArray();
                foreach (var item in VpnSites)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("outputBlobSasUrl"u8);
            writer.WriteStringValue(OutputBlobSasUri.AbsoluteUri);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GetVpnSitesConfigurationContent IJsonModel<GetVpnSitesConfigurationContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetVpnSitesConfigurationContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetVpnSitesConfigurationContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGetVpnSitesConfigurationContent(document.RootElement, options);
        }

        internal static GetVpnSitesConfigurationContent DeserializeGetVpnSitesConfigurationContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<string> vpnSites = default;
            Uri outputBlobSasUrl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("vpnSites"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    vpnSites = array;
                    continue;
                }
                if (property.NameEquals("outputBlobSasUrl"u8))
                {
                    outputBlobSasUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GetVpnSitesConfigurationContent(vpnSites ?? new ChangeTrackingList<string>(), outputBlobSasUrl, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<GetVpnSitesConfigurationContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetVpnSitesConfigurationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(GetVpnSitesConfigurationContent)} does not support writing '{options.Format}' format.");
            }
        }

        GetVpnSitesConfigurationContent IPersistableModel<GetVpnSitesConfigurationContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetVpnSitesConfigurationContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGetVpnSitesConfigurationContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GetVpnSitesConfigurationContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GetVpnSitesConfigurationContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
