// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Traffic type of gateway load balancer tunnel interface. </summary>
    public readonly partial struct GatewayLoadBalancerTunnelInterfaceType : IEquatable<GatewayLoadBalancerTunnelInterfaceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GatewayLoadBalancerTunnelInterfaceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GatewayLoadBalancerTunnelInterfaceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string InternalValue = "Internal";
        private const string ExternalValue = "External";

        /// <summary> None. </summary>
        public static GatewayLoadBalancerTunnelInterfaceType None { get; } = new GatewayLoadBalancerTunnelInterfaceType(NoneValue);
        /// <summary> Internal. </summary>
        public static GatewayLoadBalancerTunnelInterfaceType Internal { get; } = new GatewayLoadBalancerTunnelInterfaceType(InternalValue);
        /// <summary> External. </summary>
        public static GatewayLoadBalancerTunnelInterfaceType External { get; } = new GatewayLoadBalancerTunnelInterfaceType(ExternalValue);
        /// <summary> Determines if two <see cref="GatewayLoadBalancerTunnelInterfaceType"/> values are the same. </summary>
        public static bool operator ==(GatewayLoadBalancerTunnelInterfaceType left, GatewayLoadBalancerTunnelInterfaceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GatewayLoadBalancerTunnelInterfaceType"/> values are not the same. </summary>
        public static bool operator !=(GatewayLoadBalancerTunnelInterfaceType left, GatewayLoadBalancerTunnelInterfaceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GatewayLoadBalancerTunnelInterfaceType"/>. </summary>
        public static implicit operator GatewayLoadBalancerTunnelInterfaceType(string value) => new GatewayLoadBalancerTunnelInterfaceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GatewayLoadBalancerTunnelInterfaceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GatewayLoadBalancerTunnelInterfaceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
