// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection. </summary>
    public partial class GatewayCustomBgpIPAddressIPConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GatewayCustomBgpIPAddressIPConfiguration"/>. </summary>
        /// <param name="ipConfigurationId"> The IpconfigurationId of ipconfiguration which belongs to gateway. </param>
        /// <param name="customBgpIPAddress"> The custom BgpPeeringAddress which belongs to IpconfigurationId. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ipConfigurationId"/> or <paramref name="customBgpIPAddress"/> is null. </exception>
        public GatewayCustomBgpIPAddressIPConfiguration(string ipConfigurationId, string customBgpIPAddress)
        {
            Argument.AssertNotNull(ipConfigurationId, nameof(ipConfigurationId));
            Argument.AssertNotNull(customBgpIPAddress, nameof(customBgpIPAddress));

            IPConfigurationId = ipConfigurationId;
            CustomBgpIPAddress = customBgpIPAddress;
        }

        /// <summary> Initializes a new instance of <see cref="GatewayCustomBgpIPAddressIPConfiguration"/>. </summary>
        /// <param name="ipConfigurationId"> The IpconfigurationId of ipconfiguration which belongs to gateway. </param>
        /// <param name="customBgpIPAddress"> The custom BgpPeeringAddress which belongs to IpconfigurationId. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GatewayCustomBgpIPAddressIPConfiguration(string ipConfigurationId, string customBgpIPAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IPConfigurationId = ipConfigurationId;
            CustomBgpIPAddress = customBgpIPAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GatewayCustomBgpIPAddressIPConfiguration"/> for deserialization. </summary>
        internal GatewayCustomBgpIPAddressIPConfiguration()
        {
        }

        /// <summary> The IpconfigurationId of ipconfiguration which belongs to gateway. </summary>
        public string IPConfigurationId { get; set; }
        /// <summary> The custom BgpPeeringAddress which belongs to IpconfigurationId. </summary>
        public string CustomBgpIPAddress { get; set; }
    }
}
