// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Log Analytics Resources for Firewall Policy Insights. </summary>
    public partial class FirewallPolicyLogAnalyticsResources
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallPolicyLogAnalyticsResources"/>. </summary>
        public FirewallPolicyLogAnalyticsResources()
        {
            Workspaces = new ChangeTrackingList<FirewallPolicyLogAnalyticsWorkspace>();
        }

        /// <summary> Initializes a new instance of <see cref="FirewallPolicyLogAnalyticsResources"/>. </summary>
        /// <param name="workspaces"> List of workspaces for Firewall Policy Insights. </param>
        /// <param name="defaultWorkspaceId"> The default workspace Id for Firewall Policy Insights. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallPolicyLogAnalyticsResources(IList<FirewallPolicyLogAnalyticsWorkspace> workspaces, WritableSubResource defaultWorkspaceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Workspaces = workspaces;
            DefaultWorkspaceId = defaultWorkspaceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of workspaces for Firewall Policy Insights. </summary>
        public IList<FirewallPolicyLogAnalyticsWorkspace> Workspaces { get; }
        /// <summary> The default workspace Id for Firewall Policy Insights. </summary>
        internal WritableSubResource DefaultWorkspaceId { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier DefaultWorkspaceIdId
        {
            get => DefaultWorkspaceId is null ? default : DefaultWorkspaceId.Id;
            set
            {
                if (DefaultWorkspaceId is null)
                    DefaultWorkspaceId = new WritableSubResource();
                DefaultWorkspaceId.Id = value;
            }
        }
    }
}
