// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Possible Intrusion Detection profile values. </summary>
    public readonly partial struct FirewallPolicyIntrusionDetectionProfileType : IEquatable<FirewallPolicyIntrusionDetectionProfileType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FirewallPolicyIntrusionDetectionProfileType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FirewallPolicyIntrusionDetectionProfileType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string AdvancedValue = "Advanced";
        private const string ExtendedValue = "Extended";

        /// <summary> Basic. </summary>
        public static FirewallPolicyIntrusionDetectionProfileType Basic { get; } = new FirewallPolicyIntrusionDetectionProfileType(BasicValue);
        /// <summary> Standard. </summary>
        public static FirewallPolicyIntrusionDetectionProfileType Standard { get; } = new FirewallPolicyIntrusionDetectionProfileType(StandardValue);
        /// <summary> Advanced. </summary>
        public static FirewallPolicyIntrusionDetectionProfileType Advanced { get; } = new FirewallPolicyIntrusionDetectionProfileType(AdvancedValue);
        /// <summary> Extended. </summary>
        public static FirewallPolicyIntrusionDetectionProfileType Extended { get; } = new FirewallPolicyIntrusionDetectionProfileType(ExtendedValue);
        /// <summary> Determines if two <see cref="FirewallPolicyIntrusionDetectionProfileType"/> values are the same. </summary>
        public static bool operator ==(FirewallPolicyIntrusionDetectionProfileType left, FirewallPolicyIntrusionDetectionProfileType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FirewallPolicyIntrusionDetectionProfileType"/> values are not the same. </summary>
        public static bool operator !=(FirewallPolicyIntrusionDetectionProfileType left, FirewallPolicyIntrusionDetectionProfileType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FirewallPolicyIntrusionDetectionProfileType"/>. </summary>
        public static implicit operator FirewallPolicyIntrusionDetectionProfileType(string value) => new FirewallPolicyIntrusionDetectionProfileType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FirewallPolicyIntrusionDetectionProfileType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FirewallPolicyIntrusionDetectionProfileType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
