// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Firewall Policy Insights. </summary>
    public partial class FirewallPolicyInsights
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallPolicyInsights"/>. </summary>
        public FirewallPolicyInsights()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FirewallPolicyInsights"/>. </summary>
        /// <param name="isEnabled"> A flag to indicate if the insights are enabled on the policy. </param>
        /// <param name="retentionDays"> Number of days the insights should be enabled on the policy. </param>
        /// <param name="logAnalyticsResources"> Workspaces needed to configure the Firewall Policy Insights. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallPolicyInsights(bool? isEnabled, int? retentionDays, FirewallPolicyLogAnalyticsResources logAnalyticsResources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            RetentionDays = retentionDays;
            LogAnalyticsResources = logAnalyticsResources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A flag to indicate if the insights are enabled on the policy. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> Number of days the insights should be enabled on the policy. </summary>
        public int? RetentionDays { get; set; }
        /// <summary> Workspaces needed to configure the Firewall Policy Insights. </summary>
        public FirewallPolicyLogAnalyticsResources LogAnalyticsResources { get; set; }
    }
}
