// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Azure Firewall Packet Capture Parameters. </summary>
    public partial class FirewallPacketCaptureRequestContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FirewallPacketCaptureRequestContent"/>. </summary>
        public FirewallPacketCaptureRequestContent()
        {
            Flags = new ChangeTrackingList<AzureFirewallPacketCaptureFlags>();
            Filters = new ChangeTrackingList<AzureFirewallPacketCaptureRule>();
        }

        /// <summary> Initializes a new instance of <see cref="FirewallPacketCaptureRequestContent"/>. </summary>
        /// <param name="durationInSeconds"> Duration of packet capture in seconds. </param>
        /// <param name="numberOfPacketsToCapture"> Number of packets to be captured. </param>
        /// <param name="sasUri"> Upload capture location. </param>
        /// <param name="fileName"> Name of file to be uploaded to sasURL. </param>
        /// <param name="protocol"> The protocol of packets to capture. </param>
        /// <param name="flags"> The tcp-flag type to be captured. Used with protocol TCP. </param>
        /// <param name="filters"> Rules to filter packet captures. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FirewallPacketCaptureRequestContent(int? durationInSeconds, int? numberOfPacketsToCapture, Uri sasUri, string fileName, AzureFirewallNetworkRuleProtocol? protocol, IList<AzureFirewallPacketCaptureFlags> flags, IList<AzureFirewallPacketCaptureRule> filters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DurationInSeconds = durationInSeconds;
            NumberOfPacketsToCapture = numberOfPacketsToCapture;
            SasUri = sasUri;
            FileName = fileName;
            Protocol = protocol;
            Flags = flags;
            Filters = filters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Duration of packet capture in seconds. </summary>
        public int? DurationInSeconds { get; set; }
        /// <summary> Number of packets to be captured. </summary>
        public int? NumberOfPacketsToCapture { get; set; }
        /// <summary> Upload capture location. </summary>
        public Uri SasUri { get; set; }
        /// <summary> Name of file to be uploaded to sasURL. </summary>
        public string FileName { get; set; }
        /// <summary> The protocol of packets to capture. </summary>
        public AzureFirewallNetworkRuleProtocol? Protocol { get; set; }
        /// <summary> The tcp-flag type to be captured. Used with protocol TCP. </summary>
        public IList<AzureFirewallPacketCaptureFlags> Flags { get; }
        /// <summary> Rules to filter packet captures. </summary>
        public IList<AzureFirewallPacketCaptureRule> Filters { get; }
    }
}
