// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The billing type of the ExpressRoutePort resource. </summary>
    public readonly partial struct ExpressRoutePortsBillingType : IEquatable<ExpressRoutePortsBillingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRoutePortsBillingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRoutePortsBillingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MeteredDataValue = "MeteredData";
        private const string UnlimitedDataValue = "UnlimitedData";

        /// <summary> MeteredData. </summary>
        public static ExpressRoutePortsBillingType MeteredData { get; } = new ExpressRoutePortsBillingType(MeteredDataValue);
        /// <summary> UnlimitedData. </summary>
        public static ExpressRoutePortsBillingType UnlimitedData { get; } = new ExpressRoutePortsBillingType(UnlimitedDataValue);
        /// <summary> Determines if two <see cref="ExpressRoutePortsBillingType"/> values are the same. </summary>
        public static bool operator ==(ExpressRoutePortsBillingType left, ExpressRoutePortsBillingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRoutePortsBillingType"/> values are not the same. </summary>
        public static bool operator !=(ExpressRoutePortsBillingType left, ExpressRoutePortsBillingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRoutePortsBillingType"/>. </summary>
        public static implicit operator ExpressRoutePortsBillingType(string value) => new ExpressRoutePortsBillingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRoutePortsBillingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRoutePortsBillingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
