// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The peering type. </summary>
    public readonly partial struct ExpressRoutePeeringType : IEquatable<ExpressRoutePeeringType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRoutePeeringType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRoutePeeringType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzurePublicPeeringValue = "AzurePublicPeering";
        private const string AzurePrivatePeeringValue = "AzurePrivatePeering";
        private const string MicrosoftPeeringValue = "MicrosoftPeering";

        /// <summary> AzurePublicPeering. </summary>
        public static ExpressRoutePeeringType AzurePublicPeering { get; } = new ExpressRoutePeeringType(AzurePublicPeeringValue);
        /// <summary> AzurePrivatePeering. </summary>
        public static ExpressRoutePeeringType AzurePrivatePeering { get; } = new ExpressRoutePeeringType(AzurePrivatePeeringValue);
        /// <summary> MicrosoftPeering. </summary>
        public static ExpressRoutePeeringType MicrosoftPeering { get; } = new ExpressRoutePeeringType(MicrosoftPeeringValue);
        /// <summary> Determines if two <see cref="ExpressRoutePeeringType"/> values are the same. </summary>
        public static bool operator ==(ExpressRoutePeeringType left, ExpressRoutePeeringType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRoutePeeringType"/> values are not the same. </summary>
        public static bool operator !=(ExpressRoutePeeringType left, ExpressRoutePeeringType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRoutePeeringType"/>. </summary>
        public static implicit operator ExpressRoutePeeringType(string value) => new ExpressRoutePeeringType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRoutePeeringType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRoutePeeringType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
