// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> ExpressRouteLink Mac Security Configuration. </summary>
    public partial class ExpressRouteLinkMacSecConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteLinkMacSecConfig"/>. </summary>
        public ExpressRouteLinkMacSecConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteLinkMacSecConfig"/>. </summary>
        /// <param name="cknSecretIdentifier"> Keyvault Secret Identifier URL containing Mac security CKN key. </param>
        /// <param name="cakSecretIdentifier"> Keyvault Secret Identifier URL containing Mac security CAK key. </param>
        /// <param name="cipher"> Mac security cipher. </param>
        /// <param name="sciState"> Sci mode enabled/disabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExpressRouteLinkMacSecConfig(string cknSecretIdentifier, string cakSecretIdentifier, ExpressRouteLinkMacSecCipher? cipher, ExpressRouteLinkMacSecSciState? sciState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CknSecretIdentifier = cknSecretIdentifier;
            CakSecretIdentifier = cakSecretIdentifier;
            Cipher = cipher;
            SciState = sciState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Keyvault Secret Identifier URL containing Mac security CKN key. </summary>
        public string CknSecretIdentifier { get; set; }
        /// <summary> Keyvault Secret Identifier URL containing Mac security CAK key. </summary>
        public string CakSecretIdentifier { get; set; }
        /// <summary> Mac security cipher. </summary>
        public ExpressRouteLinkMacSecCipher? Cipher { get; set; }
        /// <summary> Sci mode enabled/disabled. </summary>
        public ExpressRouteLinkMacSecSciState? SciState { get; set; }
    }
}
