// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Network.Models
{
    public partial class ExpressRouteLinkMacSecConfig : IUtf8JsonSerializable, IJsonModel<ExpressRouteLinkMacSecConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExpressRouteLinkMacSecConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExpressRouteLinkMacSecConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteLinkMacSecConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExpressRouteLinkMacSecConfig)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CknSecretIdentifier))
            {
                writer.WritePropertyName("cknSecretIdentifier"u8);
                writer.WriteStringValue(CknSecretIdentifier);
            }
            if (Optional.IsDefined(CakSecretIdentifier))
            {
                writer.WritePropertyName("cakSecretIdentifier"u8);
                writer.WriteStringValue(CakSecretIdentifier);
            }
            if (Optional.IsDefined(Cipher))
            {
                writer.WritePropertyName("cipher"u8);
                writer.WriteStringValue(Cipher.Value.ToString());
            }
            if (Optional.IsDefined(SciState))
            {
                writer.WritePropertyName("sciState"u8);
                writer.WriteStringValue(SciState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExpressRouteLinkMacSecConfig IJsonModel<ExpressRouteLinkMacSecConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteLinkMacSecConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExpressRouteLinkMacSecConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExpressRouteLinkMacSecConfig(document.RootElement, options);
        }

        internal static ExpressRouteLinkMacSecConfig DeserializeExpressRouteLinkMacSecConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string cknSecretIdentifier = default;
            string cakSecretIdentifier = default;
            ExpressRouteLinkMacSecCipher? cipher = default;
            ExpressRouteLinkMacSecSciState? sciState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("cknSecretIdentifier"u8))
                {
                    cknSecretIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cakSecretIdentifier"u8))
                {
                    cakSecretIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cipher"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cipher = new ExpressRouteLinkMacSecCipher(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sciState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sciState = new ExpressRouteLinkMacSecSciState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExpressRouteLinkMacSecConfig(cknSecretIdentifier, cakSecretIdentifier, cipher, sciState, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExpressRouteLinkMacSecConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteLinkMacSecConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExpressRouteLinkMacSecConfig)} does not support writing '{options.Format}' format.");
            }
        }

        ExpressRouteLinkMacSecConfig IPersistableModel<ExpressRouteLinkMacSecConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExpressRouteLinkMacSecConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExpressRouteLinkMacSecConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExpressRouteLinkMacSecConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExpressRouteLinkMacSecConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
