// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Administrative state of the physical port. </summary>
    public readonly partial struct ExpressRouteLinkAdminState : IEquatable<ExpressRouteLinkAdminState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteLinkAdminState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRouteLinkAdminState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static ExpressRouteLinkAdminState Enabled { get; } = new ExpressRouteLinkAdminState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ExpressRouteLinkAdminState Disabled { get; } = new ExpressRouteLinkAdminState(DisabledValue);
        /// <summary> Determines if two <see cref="ExpressRouteLinkAdminState"/> values are the same. </summary>
        public static bool operator ==(ExpressRouteLinkAdminState left, ExpressRouteLinkAdminState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRouteLinkAdminState"/> values are not the same. </summary>
        public static bool operator !=(ExpressRouteLinkAdminState left, ExpressRouteLinkAdminState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRouteLinkAdminState"/>. </summary>
        public static implicit operator ExpressRouteLinkAdminState(string value) => new ExpressRouteLinkAdminState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRouteLinkAdminState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRouteLinkAdminState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
