// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Property to indicate if the Express Route Gateway has resiliency model of MultiHomed or SingleHomed. </summary>
    public readonly partial struct ExpressRouteGatewayResiliencyModel : IEquatable<ExpressRouteGatewayResiliencyModel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteGatewayResiliencyModel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRouteGatewayResiliencyModel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleHomedValue = "SingleHomed";
        private const string MultiHomedValue = "MultiHomed";

        /// <summary> SingleHomed. </summary>
        public static ExpressRouteGatewayResiliencyModel SingleHomed { get; } = new ExpressRouteGatewayResiliencyModel(SingleHomedValue);
        /// <summary> MultiHomed. </summary>
        public static ExpressRouteGatewayResiliencyModel MultiHomed { get; } = new ExpressRouteGatewayResiliencyModel(MultiHomedValue);
        /// <summary> Determines if two <see cref="ExpressRouteGatewayResiliencyModel"/> values are the same. </summary>
        public static bool operator ==(ExpressRouteGatewayResiliencyModel left, ExpressRouteGatewayResiliencyModel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRouteGatewayResiliencyModel"/> values are not the same. </summary>
        public static bool operator !=(ExpressRouteGatewayResiliencyModel left, ExpressRouteGatewayResiliencyModel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRouteGatewayResiliencyModel"/>. </summary>
        public static implicit operator ExpressRouteGatewayResiliencyModel(string value) => new ExpressRouteGatewayResiliencyModel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRouteGatewayResiliencyModel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRouteGatewayResiliencyModel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
