// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The tier of the SKU. </summary>
    public readonly partial struct ExpressRouteCircuitSkuTier : IEquatable<ExpressRouteCircuitSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRouteCircuitSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string BasicValue = "Basic";
        private const string LocalValue = "Local";

        /// <summary> Standard. </summary>
        public static ExpressRouteCircuitSkuTier Standard { get; } = new ExpressRouteCircuitSkuTier(StandardValue);
        /// <summary> Premium. </summary>
        public static ExpressRouteCircuitSkuTier Premium { get; } = new ExpressRouteCircuitSkuTier(PremiumValue);
        /// <summary> Basic. </summary>
        public static ExpressRouteCircuitSkuTier Basic { get; } = new ExpressRouteCircuitSkuTier(BasicValue);
        /// <summary> Local. </summary>
        public static ExpressRouteCircuitSkuTier Local { get; } = new ExpressRouteCircuitSkuTier(LocalValue);
        /// <summary> Determines if two <see cref="ExpressRouteCircuitSkuTier"/> values are the same. </summary>
        public static bool operator ==(ExpressRouteCircuitSkuTier left, ExpressRouteCircuitSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRouteCircuitSkuTier"/> values are not the same. </summary>
        public static bool operator !=(ExpressRouteCircuitSkuTier left, ExpressRouteCircuitSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRouteCircuitSkuTier"/>. </summary>
        public static implicit operator ExpressRouteCircuitSkuTier(string value) => new ExpressRouteCircuitSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRouteCircuitSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRouteCircuitSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
