// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Contains ServiceProviderProperties in an ExpressRouteCircuit. </summary>
    public partial class ExpressRouteCircuitServiceProviderProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitServiceProviderProperties"/>. </summary>
        public ExpressRouteCircuitServiceProviderProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitServiceProviderProperties"/>. </summary>
        /// <param name="serviceProviderName"> The serviceProviderName. </param>
        /// <param name="peeringLocation"> The peering location. </param>
        /// <param name="bandwidthInMbps"> The BandwidthInMbps. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExpressRouteCircuitServiceProviderProperties(string serviceProviderName, string peeringLocation, int? bandwidthInMbps, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceProviderName = serviceProviderName;
            PeeringLocation = peeringLocation;
            BandwidthInMbps = bandwidthInMbps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The serviceProviderName. </summary>
        public string ServiceProviderName { get; set; }
        /// <summary> The peering location. </summary>
        public string PeeringLocation { get; set; }
        /// <summary> The BandwidthInMbps. </summary>
        public int? BandwidthInMbps { get; set; }
    }
}
