// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The routes table associated with the ExpressRouteCircuit. </summary>
    public partial class ExpressRouteCircuitRoutesTable
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitRoutesTable"/>. </summary>
        internal ExpressRouteCircuitRoutesTable()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitRoutesTable"/>. </summary>
        /// <param name="network"> IP address of a network entity. </param>
        /// <param name="nextHop"> NextHop address. </param>
        /// <param name="locPrf"> Local preference value as set with the set local-preference route-map configuration command. </param>
        /// <param name="weight"> Route Weight. </param>
        /// <param name="path"> Autonomous system paths to the destination network. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExpressRouteCircuitRoutesTable(string network, string nextHop, string locPrf, int? weight, string path, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Network = network;
            NextHop = nextHop;
            LocPrf = locPrf;
            Weight = weight;
            Path = path;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> IP address of a network entity. </summary>
        public string Network { get; }
        /// <summary> NextHop address. </summary>
        public string NextHop { get; }
        /// <summary> Local preference value as set with the set local-preference route-map configuration command. </summary>
        public string LocPrf { get; }
        /// <summary> Route Weight. </summary>
        public int? Weight { get; }
        /// <summary> Autonomous system paths to the destination network. </summary>
        public string Path { get; }
    }
}
