// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Specifies the peering configuration. </summary>
    public partial class ExpressRouteCircuitPeeringConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitPeeringConfig"/>. </summary>
        public ExpressRouteCircuitPeeringConfig()
        {
            AdvertisedPublicPrefixes = new ChangeTrackingList<string>();
            AdvertisedCommunities = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitPeeringConfig"/>. </summary>
        /// <param name="advertisedPublicPrefixes"> The reference to AdvertisedPublicPrefixes. </param>
        /// <param name="advertisedCommunities"> The communities of bgp peering. Specified for microsoft peering. </param>
        /// <param name="advertisedPublicPrefixesState"> The advertised public prefix state of the Peering resource. </param>
        /// <param name="legacyMode"> The legacy mode of the peering. </param>
        /// <param name="customerASN"> The CustomerASN of the peering. </param>
        /// <param name="routingRegistryName"> The RoutingRegistryName of the configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExpressRouteCircuitPeeringConfig(IList<string> advertisedPublicPrefixes, IList<string> advertisedCommunities, ExpressRouteCircuitPeeringAdvertisedPublicPrefixState? advertisedPublicPrefixesState, int? legacyMode, int? customerASN, string routingRegistryName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AdvertisedPublicPrefixes = advertisedPublicPrefixes;
            AdvertisedCommunities = advertisedCommunities;
            AdvertisedPublicPrefixesState = advertisedPublicPrefixesState;
            LegacyMode = legacyMode;
            CustomerASN = customerASN;
            RoutingRegistryName = routingRegistryName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The reference to AdvertisedPublicPrefixes. </summary>
        public IList<string> AdvertisedPublicPrefixes { get; }
        /// <summary> The communities of bgp peering. Specified for microsoft peering. </summary>
        public IList<string> AdvertisedCommunities { get; }
        /// <summary> The advertised public prefix state of the Peering resource. </summary>
        public ExpressRouteCircuitPeeringAdvertisedPublicPrefixState? AdvertisedPublicPrefixesState { get; }
        /// <summary> The legacy mode of the peering. </summary>
        public int? LegacyMode { get; set; }
        /// <summary> The CustomerASN of the peering. </summary>
        public int? CustomerASN { get; set; }
        /// <summary> The RoutingRegistryName of the configuration. </summary>
        public string RoutingRegistryName { get; set; }
    }
}
