// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The advertised public prefix state of the Peering resource. </summary>
    public readonly partial struct ExpressRouteCircuitPeeringAdvertisedPublicPrefixState : IEquatable<ExpressRouteCircuitPeeringAdvertisedPublicPrefixState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotConfiguredValue = "NotConfigured";
        private const string ConfiguringValue = "Configuring";
        private const string ConfiguredValue = "Configured";
        private const string ValidationNeededValue = "ValidationNeeded";

        /// <summary> NotConfigured. </summary>
        public static ExpressRouteCircuitPeeringAdvertisedPublicPrefixState NotConfigured { get; } = new ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(NotConfiguredValue);
        /// <summary> Configuring. </summary>
        public static ExpressRouteCircuitPeeringAdvertisedPublicPrefixState Configuring { get; } = new ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(ConfiguringValue);
        /// <summary> Configured. </summary>
        public static ExpressRouteCircuitPeeringAdvertisedPublicPrefixState Configured { get; } = new ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(ConfiguredValue);
        /// <summary> ValidationNeeded. </summary>
        public static ExpressRouteCircuitPeeringAdvertisedPublicPrefixState ValidationNeeded { get; } = new ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(ValidationNeededValue);
        /// <summary> Determines if two <see cref="ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"/> values are the same. </summary>
        public static bool operator ==(ExpressRouteCircuitPeeringAdvertisedPublicPrefixState left, ExpressRouteCircuitPeeringAdvertisedPublicPrefixState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"/> values are not the same. </summary>
        public static bool operator !=(ExpressRouteCircuitPeeringAdvertisedPublicPrefixState left, ExpressRouteCircuitPeeringAdvertisedPublicPrefixState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"/>. </summary>
        public static implicit operator ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(string value) => new ExpressRouteCircuitPeeringAdvertisedPublicPrefixState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressRouteCircuitPeeringAdvertisedPublicPrefixState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressRouteCircuitPeeringAdvertisedPublicPrefixState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
