// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> The ARP table associated with the ExpressRouteCircuit. </summary>
    public partial class ExpressRouteCircuitArpTable
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitArpTable"/>. </summary>
        internal ExpressRouteCircuitArpTable()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExpressRouteCircuitArpTable"/>. </summary>
        /// <param name="age"> Entry age in minutes. </param>
        /// <param name="interface"> Interface address. </param>
        /// <param name="ipAddress"> The IP address. </param>
        /// <param name="macAddress"> The MAC address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExpressRouteCircuitArpTable(int? age, string @interface, string ipAddress, string macAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Age = age;
            Interface = @interface;
            IPAddress = ipAddress;
            MacAddress = macAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Entry age in minutes. </summary>
        public int? Age { get; }
        /// <summary> Interface address. </summary>
        public string Interface { get; }
        /// <summary> The IP address. </summary>
        public string IPAddress { get; }
        /// <summary> The MAC address. </summary>
        public string MacAddress { get; }
    }
}
