// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Network.Models
{
    /// <summary> Defines a managed rule group to use for exclusion. </summary>
    public partial class ExclusionManagedRuleGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExclusionManagedRuleGroup"/>. </summary>
        /// <param name="ruleGroupName"> The managed rule group for exclusion. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleGroupName"/> is null. </exception>
        public ExclusionManagedRuleGroup(string ruleGroupName)
        {
            Argument.AssertNotNull(ruleGroupName, nameof(ruleGroupName));

            RuleGroupName = ruleGroupName;
            Rules = new ChangeTrackingList<ExclusionManagedRule>();
        }

        /// <summary> Initializes a new instance of <see cref="ExclusionManagedRuleGroup"/>. </summary>
        /// <param name="ruleGroupName"> The managed rule group for exclusion. </param>
        /// <param name="rules"> List of rules that will be excluded. If none specified, all rules in the group will be excluded. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExclusionManagedRuleGroup(string ruleGroupName, IList<ExclusionManagedRule> rules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleGroupName = ruleGroupName;
            Rules = rules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExclusionManagedRuleGroup"/> for deserialization. </summary>
        internal ExclusionManagedRuleGroup()
        {
        }

        /// <summary> The managed rule group for exclusion. </summary>
        public string RuleGroupName { get; set; }
        /// <summary> List of rules that will be excluded. If none specified, all rules in the group will be excluded. </summary>
        public IList<ExclusionManagedRule> Rules { get; }
    }
}
